ORCA/M Asm65816 2.1.0

0001 BF19                       title 'Text Tools           GS ROM 3.0'
0002 BF19              ****************************************************************
0003 BF19              *                                                              *
0004 BF19              *                   Text Tools                                 *
0005 BF19              *                                                              *
0006 BF19              ****************************************************************
0007 BF19
0008 BF19
0009 BF19              ****************************************************************
0010 BF19              *                                                              *
0011 BF19              *                   Copyright (C) 1985-1989                    *
0012 BF19              *                   All Rights Reserved                        *
0013 BF19              *                   Apple Computer, Inc.                       *
0014 BF19              *                                                              *
0015 BF19              ****************************************************************
0016 BF19
0017 BF19
0018 BF19
0019 BF19              **********************************************************************
0020 BF19              *
0021 BF19              * Change history
0022 BF19              *
0023 BF19              * 21 March 88	Steven Glass
0024 BF19              *
0025 BF19              * Device error code was being returned in 8-bit mode rather
0026 BF19              * than in 16 bit mode in two calls: TextCtrl and TextStat.
0027 BF19              *
0028 BF19              * 02 Aug 88	Steven Glass
0029 BF19              *
0030 BF19              * InitTextDev ignored errors from TTDispatch.   TTDsptch did not
0031 BF19              * set the carry register and a-reg for non-error cases correctly.
0032 BF19              *
0033 BF19              * 15 Nov 88	Konstantin Othmer
0034 BF19              *
0035 BF19              * Added slot arbiter calls.  Now slot number is stored as number between
0036 BF19              *  1-15 instead of 1-7.  The conversion is done is setdevice routines.
0037 BF19              *
0038 BF19              * 01 Feb 89	Harry Yee
0039 BF19              *
0040 BF19              * Changed the version number from $0200 to $8300 (3.0P)
0041 BF19              *
0042 BF19              * 4-Nov-91	Dave Lyons
0043 BF19              *
0044 BF19              * Make GetInputDevice, GetOutputDevice, GetErrorDevice return
0045 BF19              * clean device types (no garbage in the high byte).  (Common
0046 BF19              * patch in GetDev--stz Type.)
0047 BF19              *
0048 BF19              **********************************************************************
0049 BF19
0050 BF19                       include 'all.macros' 
0051 BF19                       include '::sys.equs.asm' 
0052 BF19                       include 'e16.memory' 
0053 BF19
0054 BF19
0055 BF19              KSW      equ   $000038
0056 BF19              CSW      equ   $000036
0057 BF19
0058 BF19              ANDin    equ   $E115AA
0059 BF19              ORin     equ   ANDin+1
0060 BF19              ANDout   equ   ORin+1
0061 BF19              ORout    equ   ANDout+1
0062 BF19              ANDerr   equ   ORout+1
0063 BF19              ORerr    equ   ANDerr+1
0064 BF19              DevType  equ   ORerr+1
0065 BF19              DevPtr   equ   DevType+3
0066 BF19              InDevPtr equ   DevPtr
0067 BF19              OutDevPt equ   InDevPtr+4
0068 BF19              ErrDevPt equ   OutDevPt+4
0069 BF19              ErrHook  equ   ErrDevPt+4
0070 BF19
0071 BF19              ;
0072 BF19              ; Slot Arbiter entry point
0073 BF19              ;
0074 BF19              Slot_Arbiter equ   $E10208
0075 BF19
0076 BF19
0077 BF19              ;-----------------------------------------------------------
0078 BF19              ;
0079 BF19              ; Error Codes
0080 BF19              ;
0081 BF19              IllegalDeviceError equ   $0C01
0082 BF19
0083 BF19
0084 BF19
0085 BF19              ;-----------------------------------------------
0086 BF19              ;
0087 BF19              ;    Imported addresses
0088 BF19              ;
0089 BF19              ;-----------------------------------------------
0090 BF19
0091 BF19                       IMPORT EndCall0 
0092 BF19                       IMPORT EndCall10 
0093 BF19                       IMPORT EndCall2 
0094 BF19                       IMPORT EndCall4 
0095 BF19                       IMPORT EndCall6 
0096 BF19                       IMPORT ErrOut10 
0097 BF19                       IMPORT ErrOut2 
0098 BF19                       IMPORT ErrOut4 
0099 BF19                       IMPORT ErrOut8 
0100 BF19                       IMPORT FFEntry 
0101 BF19                       IMPORT FWentry 
0102 BF19                       IMPORT e1vectors 
0103 BF19                       IMPORT oEndCall0 
0104 BF19                       IMPORT oEndCall2 
0105 BF19                       IMPORT oEndCall4 
0106 BF19                       IMPORT oErrOut2 
0107 BF19                       IMPORT oErrOut4 
0108 BF19
0109 BF19              ;-----------------------------------------------
0110 BF19              ;
0111 BF19              ;   Forward addresses and entries
0112 BF19              ;
0113 BF19              ;-----------------------------------------------
0114 BF19
0115 BF19                       ENTRY EWrBlk 
0116 BF19                       ENTRY EWrChar 
0117 BF19                       ENTRY EWrCstr 
0118 BF19                       ENTRY EWrLine 
0119 BF19                       ENTRY EWrStr 
0120 BF19                       ENTRY GetErrDev 
0121 BF19                       ENTRY GetErrGP 
0122 BF19                       ENTRY GetInDev 
0123 BF19                       ENTRY GetInGP 
0124 BF19                       ENTRY GetItIn 
0125 BF19                       ENTRY GetOutDev 
0126 BF19                       ENTRY GetOutGP 
0127 BF19                       ENTRY MakeDDCB 
0128 BF19                       ENTRY RdBlk 
0129 BF19                       ENTRY RdChar 
0130 BF19                       ENTRY RdLine 
0131 BF19                       ENTRY SendOut 
0132 BF19                       ENTRY SetErrDev 
0133 BF19                       ENTRY SetErrGP 
0134 BF19                       ENTRY SetInDev 
0135 BF19                       ENTRY SetInGP 
0136 BF19                       ENTRY SetOutDev 
0137 BF19                       ENTRY SetOutGP 
0138 BF19                       ENTRY TTDsptch 
0139 BF19                       ENTRY TTInit 
0140 BF19                       ENTRY TTStat 
0141 BF19                       ENTRY TextCallTable 
0142 BF19                       ENTRY TextCtrl 
0143 BF19                       ENTRY TextInit 
0144 BF19                       ENTRY TextRes 
0145 BF19                       ENTRY TextShut 
0146 BF19                       ENTRY TextSp1 
0147 BF19                       ENTRY TextSp2 
0148 BF19                       ENTRY TextStat 
0149 BF19                       ENTRY TextStrt 
0150 BF19                       ENTRY TextVer 
0151 BF19                       ENTRY WrAStr 
0152 BF19                       ENTRY WrBlk 
0153 BF19                       ENTRY WrChar 
0154 BF19                       ENTRY WrCstr 
0155 BF19                       ENTRY WrLinErr 
0156 BF19                       ENTRY WrLine 
0157 BF19                       ENTRY WrString 
0158 BF19                       ENTRY readit 
0159 BF19
0160 BF19
0161 BF19              ****************************************************************
0162 BF19              *
0163 BF19              * Record of changes to the Text Tool Set.....
0164 BF19              *
0165 BF19              * Revision     Date	    Description	               Who
0166 BF19              *              3-06-86  Initial release	               RBM
0167 BF19              *              3-26-86  Beta 1.0	               RBM
0168 BF19              *              4-01-86  New Text Tools	               RBM
0169 BF19              *
0170 BF19              ****************************************************************
0171 BF19
0172 BF19                       EXPORT TextCallTable
0173 BF19              TextCallTable PROC 
0174 BF19
0175 BF19              Here                                    ; 
0176 BF19 25 00 00 00           DC L:(TheEnd-Here)/4           ; num calls +1
0177 BF1D AC BF FE 00           DC L:TTInit-1                  ; PowerUp Initialization
0178 BF21 D8 BF FE 00           DC L:TextStrt-1                ; application startup
0179 BF25 D8 BF FE 00           DC L:TextShut-1                ; application shutdown
0180 BF29 DB BF FE 00           DC L:TextVer-1                 ; version number
0181 BF2D AC BF FE 00           DC L:TextRes-1                 ; Misc. Tools Reset
0182 BF31 E3 BF FE 00           DC L:TTStat-1                  ; Reserved
0183 BF35 D8 BF FE 00           DC L:TextSp1-1                 ; Reserved
0184 BF39 D8 BF FE 00           DC L:TextSp2-1                 ; Reserved
0185 BF3D EB BF FE 00           DC L:SetInGP-1                 ; Set input global parameters
0186 BF41 09 C0 FE 00           DC L:SetOutGP-1                ; set output global parameters
0187 BF45 0E C0 FE 00           DC L:SetErrGP-1                ; set error output globals
0188 BF49 13 C0 FE 00           DC L:GetInGP-1                 ; get input global parameters
0189 BF4D 31 C0 FE 00           DC L:GetOutGP-1                ; get output global parameters
0190 BF51 36 C0 FE 00           DC L:GetErrGP-1                ; get error output globals
0191 BF55 3B C0 FE 00           DC L:SetInDev-1                ; set input device
0192 BF59 8D C0 FE 00           DC L:SetOutDev-1               ; set output device
0193 BF5D 92 C0 FE 00           DC L:SetErrDev-1               ; set error device
0194 BF61 97 C0 FE 00           DC L:GetInDev-1                ; get input device
0195 BF65 CC C0 FE 00           DC L:GetOutDev-1               ; get output device
0196 BF69 D1 C0 FE 00           DC L:GetErrDev-1               ; get error device
0197 BF6D D6 C0 FE 00           DC L:TextInit-1                ; initialize text device
0198 BF71 5C C1 FE 00           DC L:TextCtrl-1                ; control text device
0199 BF75 92 C1 FE 00           DC L:TextStat-1                ; return text device status
0200 BF79 BE C1 FE 00           DC L:WrChar-1                  ; write character to device
0201 BF7D C1 C1 FE 00           DC L:EWrChar-1                 ; write character to error device
0202 BF81 13 C2 FE 00           DC L:WrLine-1                  ; write line to output device
0203 BF85 16 C2 FE 00           DC L:EWrLine-1                 ; write line to error device
0204 BF89 35 C2 FE 00           DC L:WrString-1                ; write string to device
0205 BF8D 38 C2 FE 00           DC L:EWrStr-1                  ; write string to error device
0206 BF91 63 C2 FE 00           DC L:WrBlk-1                   ; write text to output device
0207 BF95 66 C2 FE 00           DC L:EWrBlk-1                  ; write text to error device
0208 BF99 92 C2 FE 00           DC L:WrCstr-1                  ; write C-String to output device
0209 BF9D 95 C2 FE 00           DC L:EWrCstr-1                 ; write C-String to error device
0210 BFA1 B5 C2 FE 00           DC L:RdChar-1                  ; read character from input device
0211 BFA5 FD C2 FE 00           DC L:RdBlk-1                   ; read block from input device
0212 BFA9 49 C3 FE 00           DC L:RdLine-1                  ; read line from input device
0213 BFAD
0214 BFAD              TheEnd                                  ; 
0215 BFAD
0216 BFAD                       ENDP 
0217 BFAD
0218 BFAD              ;          copy  text.tools/glue
0219 BFAD              ****************************************************************
0220 BFAD              *
0221 BFAD              * STANDARD TOOL CALLS................................
0222 BFAD              *
0223 BFAD              * BOOTINIT:    Sets the default parameters as follows
0224 BFAD              *              Input, Output & Error Device type  = BASIC in slot #3
0225 BFAD              *              AND masks set to $FF
0226 BFAD              *              OR masks set to $80
0227 BFAD              *
0228 BFAD              * STARTUPINIT: Does nothing
0229 BFAD              *
0230 BFAD              * SHUTDOWN:    Does nothing
0231 BFAD              *
0232 BFAD              * VERSION:     Returns the current version number
0233 BFAD              *
0234 BFAD              * RESET:       Sets the BASIC input & ouput hooks back
0235 BFAD              *              Sets the default parameters as follows
0236 BFAD              *              Input & Output Device type = BASIC in slot #3
0237 BFAD              *              AND masks set to $FF
0238 BFAD              *              OR masks set to $80
0239 BFAD              *
0240 BFAD              * STATUS:      Always returns with ACTIVE
0241 BFAD              *
0242 BFAD              * SPARE1:      Does nothing
0243 BFAD              *
0244 BFAD              * SPARE2:      Does nothing
0245 BFAD              *
0246 BFAD              ****************************************************************
0247 BFAD                       EXPORT TTInit
0248 BFAD              TTInit   PROC                           ; Tool Boot Initialization
0249 BFAD
0250 BFAD                       EXPORT TextRes
0251 BFAD              TextRes                                 ;       
0252 BFAD 8B                    phb   
0253 BFAE F4 15 E1              pea   ANDin/256
0254 BFB1 AB                    plb   
0255 BFB2 AB                    plb   
0256 BFB3 A2 0E 00              ldx   #$000E                   ; initialize or mask and loc.
0257 BFB6                       EXPORT TTPloop
0258 BFB6              TTPloop                                 ; 
0259 BFB6 9E B0 15              stz   |DevType,x
0260 BFB9 CA                    dex   
0261 BFBA CA                    dex   
0262 BFBB 10 F9                 bpl   TTPloop
0263 BFBD A9 FF 80              lda   #$80FF                   ; set global AND masks
0264 BFC0 8D AA 15              sta   |ANDin
0265 BFC3 8D AC 15              sta   |ANDout
0266 BFC6 8D AE 15              sta   |ANDerr
0267 BFC9 A9 03 00              lda   #0003
0268 BFCC 8D B3 15              sta   |InDevPtr                ; devices in slot 3
0269 BFCF 8D B7 15              sta   |OutDevPt
0270 BFD2 8D BB 15              sta   |ErrDevPt
0271 BFD5 AB                    plb   
0272 BFD6 4C DF FB              jmp   oEndCall0
0273 BFD9
0274 BFD9
0275 BFD9                       EXPORT TextStrt
0276 BFD9              TextStrt                                ;       ; Tool Start Up
0277 BFD9                       EXPORT TextShut
0278 BFD9              TextShut                                ;       ; Tool Shut Down
0279 BFD9                       EXPORT TextSp1
0280 BFD9              TextSp1                                 ;       
0281 BFD9                       EXPORT TextSp2
0282 BFD9              TextSp2                                 ;       
0283 BFD9 4C DF FB              jmp   oEndCall0
0284 BFDC
0285 BFDC                       ENDP 
0286 BFDC
0287 BFDC
0288 BFDC                       EXPORT TextVer
0289 BFDC              TextVer  PROC 
0290 BFDC
0291 BFDC              RTL1     equ   1
0292 BFDC              RTL2     equ   RTL1+3
0293 BFDC              Result   equ   RTL2+3
0294 BFDC
0295 BFDC              Version  equ   $0300                    ; current version number
0296 BFDC
0297 BFDC A9 00 03              lda   #version                 ; get MT version #
0298 BFDF 83 07                 sta   Result,s                 ; pass to caller
0299 BFE1 4C DF FB              jmp   oEndCall0
0300 BFE4
0301 BFE4                       ENDP 
0302 BFE4
0303 BFE4
0304 BFE4                       EXPORT TTStat
0305 BFE4              TTStat   PROC 
0306 BFE4
0307 BFE4              rtl1     equ   1
0308 BFE4              rtl2     equ   rtl1+3
0309 BFE4              TheStatus equ   rtl2+3
0310 BFE4
0311 BFE4 A9 FF FF              lda   #$FFFF                   ; indicate tool active
0312 BFE7 83 07                 sta   TheStatus,s
0313 BFE9 4C DF FB              jmp   oEndCall0
0314 BFEC
0315 BFEC                       ENDP 
0316 BFEC              ;          copy  text.tools/globals
0317 BFEC                       EXPORT SetInGP
0318 BFEC              SetInGP  PROC 
0319 BFEC              ****************************************************************
0320 BFEC              *
0321 BFEC              * Set Input Global Parameters
0322 BFEC              *
0323 BFEC              *      Input   Word	    AND mask
0324 BFEC              *      Input   Word	    OR mask
0325 BFEC              * sp->
0326 BFEC              *
0327 BFEC              ****************************************************************
0328 BFEC
0329 BFEC              OrigDir  equ   1
0330 BFEC              rtl1     equ   OrigDir+2
0331 BFEC              rtl2     equ   rtl1+3
0332 BFEC              maskor   equ   rtl2+3
0333 BFEC              maskand  equ   maskor+2
0334 BFEC
0335 BFEC A2 00 00              ldx   #0                       ; index input globals
0336 BFEF                       EXPORT SetG
0337 BFEF              SetG                                    ; 
0338 BFEF 0B                    phd                            ; save direct page
0339 BFF0 3B                    tsc                            ; set stack to zp
0340 BFF1 5B                    tcd   
0341 BFF2 8B                    phb   
0342 BFF3 F4 15 E1              pea   ANDin/256
0343 BFF6 AB                    plb   
0344 BFF7 AB                    plb   
0345 BFF8 E2 20                 sep   #$20                     ; 8 bit 'm'
0346 BFFA                       longa off
0347 BFFA A5 09                 lda   maskor                   ; set input OR mask
0348 BFFC 9D AB 15              sta   |ORin,x
0349 BFFF A5 0B                 lda   maskand                  ; set input AND mask
0350 C001 9D AA 15              sta   |ANDin,x
0351 C004 AB                    plb   
0352 C005 C2 20                 rep   #$20                     ; 16 bit 'm'
0353 C007                       longa on
0354 C007 4C 0E FC              jmp   EndCall4
0355 C00A
0356 C00A                       ENDP 
0357 C00A
0358 C00A
0359 C00A
0360 C00A                       EXPORT SetOutGP
0361 C00A              SetOutGP PROC 
0362 C00A              ****************************************************************
0363 C00A              *
0364 C00A              * Set Output Global Parameters
0365 C00A              *
0366 C00A              *      Input   Word     AND mask
0367 C00A              *      Input   Word     OR mask
0368 C00A              * sp->
0369 C00A              *
0370 C00A              ****************************************************************
0371 C00A
0372 C00A A2 02 00              ldx   #2                       ; index output globals
0373 C00D 80 E0                 bra   SetG
0374 C00F
0375 C00F                       ENDP 
0376 C00F
0377 C00F                       EXPORT SetErrGP
0378 C00F              SetErrGP PROC 
0379 C00F              ****************************************************************
0380 C00F              *
0381 C00F              * Set Error Output Global Parameters
0382 C00F              *
0383 C00F              *      Input     Word     AND mask
0384 C00F              *      Input     Word     OR mask
0385 C00F              * sp->
0386 C00F              *
0387 C00F              ****************************************************************
0388 C00F
0389 C00F A2 04 00              ldx   #4                       ; index error globals
0390 C012 80 DB                 bra   SetG
0391 C014
0392 C014                       ENDP 
0393 C014
0394 C014
0395 C014                       EXPORT GetInGP
0396 C014              GetInGP  PROC 
0397 C014              ****************************************************************
0398 C014              *
0399 C014              * Get Input Global Parameters
0400 C014              *
0401 C014              *      Input     Word     Space for result
0402 C014              *      Input     Word     Space for result
0403 C014              * sp->
0404 C014              *
0405 C014              *      Output    Word     AND mask for input device
0406 C014              *      Output    Word     OR mask for input device
0407 C014              * sp->
0408 C014              *
0409 C014              ****************************************************************
0410 C014
0411 C014              OrigDir  equ   1
0412 C014              rtl1     equ   OrigDir+2
0413 C014              rtl2     equ   rtl1+3
0414 C014              maskor   equ   rtl2+3
0415 C014              maskand  equ   maskor+2
0416 C014
0417 C014 A2 00 00              ldx   #0                       ; index input globals
0418 C017                       EXPORT GetG
0419 C017              GetG                                    ; 
0420 C017 0B                    phd                            ; turn stack into zp
0421 C018 3B                    tsc   
0422 C019 5B                    tcd   
0423 C01A 8B                    phb   
0424 C01B F4 15 E1              pea   ANDin/256
0425 C01E AB                    plb   
0426 C01F AB                    plb   
0427 C020 E2 20                 sep   #$20                     ; 8 bit 'm'
0428 C022                       longa off
0429 C022 BD AB 15              lda   |ORin,x                  ; get OR mask
0430 C025 85 09                 sta   maskor
0431 C027 BD AA 15              lda   |ANDin,x                 ; get AND mask
0432 C02A 85 0B                 sta   maskand
0433 C02C C2 20                 rep   #$20                     ; 16 bit 'm'
0434 C02E                       longa on
0435 C02E AB                    plb   
0436 C02F 4C E0 FB              jmp   EndCall0
0437 C032
0438 C032                       ENDP 
0439 C032
0440 C032
0441 C032
0442 C032
0443 C032                       EXPORT GetOutGP
0444 C032              GetOutGP PROC 
0445 C032              ****************************************************************
0446 C032              *
0447 C032              * Get Output Global Parameters
0448 C032              *
0449 C032              *      Input     Word     Space for result
0450 C032              *      Input     Word     Space for result
0451 C032              * sp->
0452 C032              *
0453 C032              *      Output    Word     AND mask for output device
0454 C032              *      Output    Word     OR mask for output device
0455 C032              * sp->
0456 C032              *
0457 C032              ****************************************************************
0458 C032
0459 C032 A2 02 00              ldx   #2                       ; index output globals
0460 C035 80 E0                 bra   GetG
0461 C037
0462 C037                       ENDP 
0463 C037
0464 C037                       EXPORT GetErrGP
0465 C037              GetErrGP PROC 
0466 C037              ****************************************************************
0467 C037              *
0468 C037              * Get Error Output Device Global Parameters
0469 C037              *
0470 C037              *      Input     Word     Space for result
0471 C037              *      Input     Word     Space for result
0472 C037              * sp->
0473 C037              *
0474 C037              *      Output    Word     AND mask for error device
0475 C037              *      Output    Word     OR mask for error device
0476 C037              * sp->
0477 C037              *
0478 C037              ****************************************************************
0479 C037
0480 C037 A2 04 00              ldx   #4                       ; index error globals
0481 C03A 80 DB                 bra   GetG
0482 C03C
0483 C03C                       ENDP 
0484 C03C
0485 C03C
0486 C03C
0487 C03C                       EXPORT SetInDev
0488 C03C              SetInDev PROC 
0489 C03C              ****************************************************************
0490 C03C              *
0491 C03C              * Set INPUT device type and location.
0492 C03C              *
0493 C03C              *      Input     Word       Device type
0494 C03C              *      Input     LongWord   Device location (Addr or Slot)
0495 C03C              * sp->
0496 C03C              *
0497 C03C              *
0498 C03C              * Change History:
0499 C03C              *
0500 C03C              * Nov. 16 '88	Konstantin Othmer
0501 C03C              *
0502 C03C              * If it's a slot (and not a ram driver), we check
0503 C03C              * whether or not the slot is internal or external.  If it's external,
0504 C03C              * we add 8 to the slot number because this is how the arbiter numbers
0505 C03C              * slots.
0506 C03C              *
0507 C03C              ****************************************************************
0508 C03C
0509 C03C              OrigDB   equ   1
0510 C03C              OrigDir  equ   OrigDB+1
0511 C03C              rtl1     equ   OrigDir+2
0512 C03C              rtl2     equ   rtl1+3
0513 C03C              Location equ   rtl2+3
0514 C03C              Type     equ   Location+4
0515 C03C
0516 C03C A2 00 00              ldx   #0                       ; this is the input dev
0517 C03F                       EXPORT SetDev
0518 C03F              SetDev                                  ; 
0519 C03F 0B                    phd                            ; turn stack into zp
0520 C040 8B                    phb   
0521 C041 3B                    tsc   
0522 C042 5B                    tcd   
0523 C043 F4 15 E1              pea   DevType/256              ; point at parameters
0524 C046 AB                    plb   
0525 C047 AB                    plb   
0526 C048 8A                    txa   
0527 C049 0A                    asl   a
0528 C04A 0A                    asl   a
0529 C04B A8                    tay   
0530 C04C E2 20                 sep   #$20                     ; 8 bit 'm'
0531 C04E A5 0E                 lda   type                     ; set device type
0532 C050 9D B0 15              sta   |DevType,x
0533 C053 C2 20                 rep   #$20                     ; 16 bit 'm'
0534 C055 A5 0A                 lda   Location                 ; set location
0535 C057 99 B3 15              sta   |DevPtr,y
0536 C05A A5 0C                 lda   Location+2
0537 C05C 99 B5 15              sta   |DevPtr+2,y
0538 C05F              ;
0539 C05F              ; If it's a RAM based driver, we do nothing.
0540 C05F              ;  If it's a slot number, we leave numbers between 9 and 15 alone (hopefully user 
0541 C05F              ;   knows about arbiter slot numbering), but we convert numbers between 1 and 7 to
0542 C05F              ;  1-15 depending on whether or not the slot is currently internal or external.
0543 C05F              ;  If internal we leave alone.  We add 8 to external slots.
0544 C05F              ;
0545 C05F A5 0E                 lda   type
0546 C061 C9 02 00              cmp   #2
0547 C064 F0 24                 beq   DevPtrOK                 ;Ram based driver
0548 C066 B9 B3 15              lda   |DevPtr,y                ;get slot number
0549 C069 C9 08 00              cmp   #8                       ;is it an old slot number (7 or less)?
0550 C06C B0 1C                 bcs   DevPtrOK                 ;branch if no
0551 C06E              ;
0552 C06E              ; Here we check to see if the slot is internal or external
0553 C06E              ;
0554 C06E
0555 C06E 5A                    phy                            ;save index
0556 C06F 48                    pha                            ;save slot number
0557 C070 A9 00 80              lda   #$8000                   ;get slot configuration in x
0558 C073 22 08 02 E1           jsl   slot_arbiter             ;
0559 C077 8A                    txa                            ;bit encoded slot information to a
0560 C078 FA                    plx                            ;get saved slot number
0561 C079 7A                    ply                            ;restore index
0562 C07A
0563 C07A 4A                    lsr   a                        ;alignment
0564 C07B
0565 C07B 4A           DevLoop  lsr   a                        ;get relevent bit in carry
0566 C07C CA                    dex   
0567 C07D D0 FC                 bne   DevLoop
0568 C07F B0 09                 bcs   DevPtrOK                 ;slot is internal and DevPtr is OK
0569 C081              ;
0570 C081              ;It's an external slot.  Add 8 to slot number and save in DevPtr
0571 C081              ;
0572 C081 B9 B3 15              lda   |DevPtr,y                ;slot number
0573 C084 09 08 00              ora   #$0008                   ;bit 4 indicates external
0574 C087 99 B3 15              sta   |DevPtr,y
0575 C08A
0576 C08A              DevPtrOK  
0577 C08A AB                    plb   
0578 C08B 4C 24 FC              jmp   EndCall6
0579 C08E
0580 C08E
0581 C08E
0582 C08E                       EXPORT SetOutDev
0583 C08E              SetOutDev                               ; 
0584 C08E              ****************************************************************
0585 C08E              *
0586 C08E              * Set OUTPUT device type and location.
0587 C08E              *
0588 C08E              *      Input     Word       Device type
0589 C08E              *      Input     LongWord   Device location (Addr or Slot)
0590 C08E              * sp->
0591 C08E              *
0592 C08E              ****************************************************************
0593 C08E
0594 C08E A2 01 00              ldx   #1                       ; this is the Output dev
0595 C091 80 AC                 bra   SetDev
0596 C093
0597 C093
0598 C093
0599 C093                       EXPORT SetErrDev
0600 C093              SetErrDev                               ; 
0601 C093              ****************************************************************
0602 C093              *
0603 C093              * Set ERROR device type and location.
0604 C093              *
0605 C093              *      Input     Word       Device type
0606 C093              *      Input     LongWord   Device location (Addr or Slot)
0607 C093              * sp->
0608 C093              *
0609 C093              ****************************************************************
0610 C093
0611 C093 A2 02 00              ldx   #2                       ; this is the Error dev
0612 C096 80 A7                 bra   SetDev
0613 C098
0614 C098
0615 C098
0616 C098
0617 C098                       EXPORT GetInDev
0618 C098              GetInDev                                ; 
0619 C098              ****************************************************************
0620 C098              *
0621 C098              * Get INPUT device type and location.
0622 C098              *
0623 C098              *      Input      Word      Space for result
0624 C098              *      Input      LongWord  Space for result
0625 C098              * sp->
0626 C098              *
0627 C098              *      Output     Word      Device type
0628 C098              *      Output     LongWord  Device location (Addr or Slot)
0629 C098              * sp->
0630 C098              *
0631 C098              ****************************************************************
0632 C098
0633 C098 A2 00 00              ldx   #0                       ; this is the input dev
0634 C09B                       EXPORT GetDev
0635 C09B              GetDev                                  ; 
0636 C09B 0B                    phd                            ; turn stack into zp
0637 C09C 8B                    phb   
0638 C09D 3B                    tsc   
0639 C09E 5B                    tcd   
0640 C09F F4 15 E1              pea   DevType/256              ; point at parameters
0641 C0A2 AB                    plb   
0642 C0A3 AB                    plb   
0643 C0A4 8A                    txa   
0644 C0A5 0A                    asl   a
0645 C0A6 0A                    asl   a
0646 C0A7 A8                    tay   
0647 C0A8 E2 20                 sep   #$20                     ; 8 bit 'm'
0648 C0AA BD B0 15              lda   |DevType,x               ; get the device type
0649 C0AD 85 0E                 sta   Type
0650 C0AF C2 20                 rep   #$20                     ; 16 bit 'm'
0651 C0B1 B9 B3 15              lda   |DevPtr,y                ; get the device location
0652 C0B4 85 0A                 sta   Location
0653 C0B6 B9 B5 15              lda   |DevPtr+2,y
0654 C0B9 85 0C                 sta   Location+2
0655 C0BB A5 0E                 lda   Type
0656 C0BD C9 02 00              cmp   #2                       ;Ram based driver?
0657 C0C0 F0 07                 beq   GetDone                  ;not a slot - we're done
0658 C0C2              ;
0659 C0C2              ; It's a slot: convert it to number between 1 and 7 (8-15 is external)
0660 C0C2              ;
0661 C0C2 A5 0A                 lda   Location
0662 C0C4 29 07 00              and   #$07                     ;convert to 1-7
0663 C0C7 85 0A                 sta   Location
0664 C0C9
0665 C0C9              GetDone   
0666 C0C9 AB                    plb   
0667 C0CA 4C E0 FB              jmp   EndCall0
0668 C0CD
0669 C0CD
0670 C0CD
0671 C0CD                       EXPORT GetOutDev
0672 C0CD              GetOutDev                               ; 
0673 C0CD              ****************************************************************
0674 C0CD              *
0675 C0CD              * Get OUTPUT device type and location.
0676 C0CD              *
0677 C0CD              *      Input      Word      Space for result
0678 C0CD              *      Input      LongWord  Space for result
0679 C0CD              * sp->
0680 C0CD              *
0681 C0CD              *      Output     Word      Device type
0682 C0CD              *      Output     LongWord  Device location (Addr or Slot)
0683 C0CD              * sp->
0684 C0CD              *
0685 C0CD              ****************************************************************
0686 C0CD
0687 C0CD A2 01 00              ldx   #1                       ; this is the output dev
0688 C0D0 80 C9                 bra   GetDev
0689 C0D2
0690 C0D2
0691 C0D2
0692 C0D2                       EXPORT GetErrDev
0693 C0D2              GetErrDev                               ; 
0694 C0D2              ****************************************************************
0695 C0D2              *
0696 C0D2              * Get ERROR device type and location.
0697 C0D2              *
0698 C0D2              *      Input      Word      Space for result
0699 C0D2              *      Input      LongWord  Space for result
0700 C0D2              * sp->
0701 C0D2              *
0702 C0D2              *      Output     Word      Device type
0703 C0D2              *      Output     LongWord  Device location (Addr or Slot)
0704 C0D2              * sp->
0705 C0D2              *
0706 C0D2              ****************************************************************
0707 C0D2
0708 C0D2 A2 02 00              ldx   #2                       ; this is the error dev
0709 C0D5 80 C4                 bra   GetDev
0710 C0D7
0711 C0D7
0712 C0D7                       ENDP 
0713 C0D7
0714 C0D7
0715 C0D7
0716 C0D7              TextInit PROC 
0717 C0D7              ****************************************************************
0718 C0D7              *
0719 C0D7              * TEXT DEVICE INITIALIZATION
0720 C0D7              *
0721 C0D7              *      Input     Word     Device to initialize
0722 C0D7              * sp->                    0 = Input device
0723 C0D7              *                         1 = Output device
0724 C0D7              *                         2 = Error output device
0725 C0D7              *
0726 C0D7              * If the device is a basic device, the I/O hooks are set
0727 C0D7              * to the init entry for the device being called.
0728 C0D7              *
0729 C0D7              * Modification History:
0730 C0D7              *
0731 C0D7              * 11 Sep 86    RBM      Updated to handle save/restore of I/O
0732 C0D7              *      hooks when initing an error device.
0733 C0D7              *
0734 C0D7              * 02 Aug 88    SEG      Look for error from TTDispatch
0735 C0D7              *
0736 C0D7              * 15 Oct 88    SEG      Add call to you've got to be kidding.
0737 C0D7              *
0738 C0D7              * 31 Oct 88    SEG      Trick or Treat.  Fix stack imbalance in 
0739 C0D7              *                       error code:  extra word was left on stack
0740 C0D7              *                       when input was out of range.
0741 C0D7              *
0742 C0D7              *
0743 C0D7              ****************************************************************
0744 C0D7
0745 C0D7              ;-----------------------------------------------------------
0746 C0D7              ;
0747 C0D7              ; Yet another horrible hack from the people who brought you...
0748 C0D7              ;
0749 C0D7              ; This is the only time we can be sure that the OS
0750 C0D7              ; will call the ROM after the drivers are back in place and
0751 C0D7              ; before the application runs.
0752 C0D7              ;
0753 C0D7              ; So we call YouveGotToBeKidding and hope for the best.
0754 C0D7              ;
0755 C0D7                       import YouveGotToBeKidding 
0756 C0D7 22 A1 E5 FC           jsl   YouveGotToBeKidding
0757 C0DB                        
0758 C0DB              ;-----------------------------------------------------------
0759 C0DB
0760 C0DB
0761 C0DB              hookspace equ   1
0762 C0DB              OrigDBR  equ   hookspace+2
0763 C0DB              OrigDir  equ   OrigDBR+1
0764 C0DB              rtl1     equ   OrigDir+2
0765 C0DB              rtl2     equ   rtl1+3
0766 C0DB              device   equ   rtl2+3
0767 C0DB
0768 C0DB 0B                    phd                            ; Save D
0769 C0DC 8B                    phb                            ; save B
0770 C0DD F4 00 00              pea   $0000                    ; Push 0
0771 C0E0 3B                    tsc                            ; turn stack into zp
0772 C0E1 5B                    tcd   
0773 C0E2
0774 C0E2 A5 0C                 lda   Device
0775 C0E4 C9 03 00              cmp   #3                       ;input, output, or error ?
0776 C0E7 90 09                 bcc   DeviceOK
0777 C0E9
0778 C0E9 A2 01 0C              ldx   #IllegalDeviceError      ; illegal device error
0779 C0EC 68                    pla                            ; pull off that zero
0780 C0ED AB                    plb                            ; restore b
0781 C0EE 2B                    pld                            ; restore d
0782 C0EF 4C FC FB              jmp   oErrOut2                 ; return the error
0783 C0F2
0784 C0F2
0785 C0F2              DeviceOK  
0786 C0F2
0787 C0F2 E2 30                 sep   #$30                     ; switch to 8 bit mode
0788 C0F4                       longa off
0789 C0F4                       longi off
0790 C0F4 F4 15 E1              pea   DevType/256              ; point at device type
0791 C0F7 AB                    plb   
0792 C0F8 AB                    plb   
0793 C0F9 A8                    tay                            ; index to get type 
0794 C0FA B9 B0 15              lda   |DevType,y               ; get device type
0795 C0FD D0 2C                 bne   NotBASIC                 ; if not basic, leave hooks
0796 C0FF 98                    tya                            ; point at device pointer
0797 C100 0A                    asl   a
0798 C101 0A                    asl   a
0799 C102 AA                    tax   
0800 C103 C2 20                 rep   #$20                     ; 16 bit 'm'
0801 C105                       longa on
0802 C105 BD B3 15              lda   |DevPtr,x                ; get slot # = $000n
0803 C108              ;
0804 C108              ; since slot arbiter slot numbers go from 1-15, we have to convert to 1-7
0805 C108              ;
0806 C108 29 07 00              and   #7
0807 C10B              ;
0808 C10B EB                    xba                            ; $0n00
0809 C10C 09 00 C0              ora   #$C000                   ; build $Cn00
0810 C10F C0 00                 cpy   #0                       ; is it the input device?
0811 C111 D0 06                 bne   SetOutHk                 ; no
0812 C113 8F 38 00 00           sta   >KSW                     ; set input hook
0813 C117 80 10                 bra   HookSet
0814 C119
0815 C119
0816 C119              SetOutHk                                ; 
0817 C119 C0 02                 cpy   #2                       ; is this an error device?
0818 C11B D0 08                 bne   noterrdev                ; no
0819 C11D 48                    pha                            ; save new output hook
0820 C11E AF 36 00 00           lda   >csw                     ; and save current output hook
0821 C122 85 01                 sta   hookspace
0822 C124 68                    pla   
0823 C125
0824 C125
0825 C125              noterrdev                               ; 
0826 C125 8F 36 00 00           sta   >CSW                     ; set output hook
0827 C129
0828 C129
0829 C129              HookSet                                 ; 
0830 C129 E2 20                 sep   #$20                     ; 8 bit 'm'
0831 C12B                       longa off
0832 C12B
0833 C12B
0834 C12B              NotBASIC                                ; 
0835 C12B A9 00                 lda   #0                       ; its an init call
0836 C12D 20 5D C5              jsr   MakeDDCB                 ; build the DDCB
0837 C130 48                    pha                            ; save the real DDCB
0838 C131 48                    pha   
0839 C132 29 7F                 and   #%01111111               ; init is always a standard device
0840 C134 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
0841 C136                       longa on
0842 C136                       longi on
0843 C136 F4 00 00              pea   $0000                    ; init character
0844 C139 20 89 C3              jsr   TTDsptch                 ; dispatch to device
0845 C13C
0846 C13C AA                    tax                            ; put any error code into x-reg
0847 C13D
0848 C13D 68                    pla                            ; get status and ignore it
0849 C13E
0850 C13E 68                    pla                            ; get the real DDCB
0851 C13F 08                    php                            ; save dispatch error flag
0852 C140 29 C0 00              and   #$00C0                   ; Y = Error and not basic
0853 C143 C9 80 00              cmp   #$0080                   ; was it a basic error call?
0854 C146 D0 0E                 bne   norestore                ; no
0855 C148 AF 36 00 00           lda   >csw                     ; get error device hook
0856 C14C 8F BF 15 E1           sta   >ErrHook                 ; and save for error dispatches
0857 C150 A5 01                 lda   hookspace
0858 C152 8F 36 00 00           sta   >csw                     ; restore basic output hook
0859 C156
0860 C156
0861 C156              norestore  
0862 C156
0863 C156 28                    plp                            ; get dispatch error flag
0864 C157 68                    pla                            ; clean off hookspace
0865 C158 AB                    plb   
0866 C159 2B                    pld   
0867 C15A 4C FC FB              jmp   oErrOut2                 ; rely on x being correct!
0868 C15D
0869 C15D                       ENDP 
0870 C15D
0871 C15D
0872 C15D
0873 C15D                       EXPORT TextCtrl
0874 C15D              TextCtrl PROC 
0875 C15D              ****************************************************************
0876 C15D              *
0877 C15D              * TEXT DEVICE CONTROL
0878 C15D              *
0879 C15D              *      Input   Word     Device to control
0880 C15D              *      Input   Word     Control code
0881 C15D              * sp->
0882 C15D              *
0883 C15D              * Change history
0884 C15D              *
0885 C15D              * 21 March 88	Steven Glass
0886 C15D              *
0887 C15D              * Device error code was being returned in 8-bit mode rather
0888 C15D              * than in 16 bit mode.
0889 C15D              *
0890 C15D              *
0891 C15D              ****************************************************************
0892 C15D
0893 C15D              OrigDB   equ   1
0894 C15D              OrigDir  equ   OrigDB+1
0895 C15D              rtl1     equ   OrigDir+2
0896 C15D              rtl2     equ   rtl1+3
0897 C15D              CtrlCode equ   rtl2+3
0898 C15D              Device   equ   CtrlCode+2
0899 C15D
0900 C15D 0B                    phd                            ; turn stack into zp
0901 C15E 8B                    phb   
0902 C15F 3B                    tsc   
0903 C160 5B                    tcd   
0904 C161 E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
0905 C163                       longa off
0906 C163                       longi off
0907 C163 A5 0C                 lda   device                   ; get device type
0908 C165 C9 03                 cmp   #3                       ; is is a legal type?
0909 C167 90 0A                 blt   DevOK                    ; yes
0910 C169                       EXPORT TypeErr
0911 C169              TypeErr                                 ; 
0912 C169 C2 30                 rep   #$30
0913 C16B                       longa on
0914 C16B                       longi on
0915 C16B A2 01 0C              ldx   #IllegalDeviceError      ; else bad dev error
0916 C16E AB                    plb   
0917 C16F 2B                    pld   
0918 C170                       EXPORT CtrlErr
0919 C170              CtrlErr                                 ; 
0920 C170 4C FC FB              jmp   oErrOut2
0921 C173
0922 C173
0923 C173                       longa off
0924 C173                       longi off
0925 C173                       EXPORT DevOK
0926 C173              DevOK                                   ; 
0927 C173 A8                    tay                            ; index to get type
0928 C174 F4 15 E1              pea   DevType/256
0929 C177 AB                    plb   
0930 C178 AB                    plb   
0931 C179 B9 B0 15              lda   |DevType,y               ; error if its a BASIC device
0932 C17C F0 EB                 beq   TypeErr
0933 C17E A9 04                 lda   #4                       ; this is a control call
0934 C180 20 5D C5              jsr   MakeDDCB                 ; build the DDCB
0935 C183 C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
0936 C185                       longa on
0937 C185                       longi on
0938 C185 A6 0A                 ldx   CtrlCode                 ; get control code
0939 C187 DA                    phx   
0940 C188 20 89 C3              jsr   TTDsptch                 ; dispatch to device
0941 C18B FA                    plx                            ; get status
0942 C18C AB                    plb   
0943 C18D 2B                    pld   
0944 C18E B0 E0                 bcs   CtrlErr                  ; if error occured
0945 C190 4C 0D FC              jmp   oEndCall4
0946 C193
0947 C193                       ENDP 
0948 C193
0949 C193
0950 C193
0951 C193
0952 C193                       EXPORT TextStat
0953 C193              TextStat PROC 
0954 C193              ****************************************************************
0955 C193              *
0956 C193              * TEXT DEVICE STATUS
0957 C193              *
0958 C193              *      Input   Word	    Device to request status
0959 C193              *      Input   Word	    Request code
0960 C193              * sp->
0961 C193              *
0962 C193              *
0963 C193              * Change history
0964 C193              *
0965 C193              * 21 March 88	Steven Glass
0966 C193              *
0967 C193              * Device error code was being returned in 8-bit mode rather
0968 C193              * than in 16 bit mode.
0969 C193              *
0970 C193              ****************************************************************
0971 C193
0972 C193              OrigDB   equ   1
0973 C193              OrigDir  equ   OrigDB+1
0974 C193              rtl1     equ   OrigDir+2
0975 C193              rtl2     equ   rtl1+3
0976 C193              StatCode equ   rtl2+3
0977 C193              Device   equ   StatCode+2
0978 C193
0979 C193 0B                    phd                            ; turn stack into zp
0980 C194 8B                    phb   
0981 C195 3B                    tsc   
0982 C196 5B                    tcd   
0983 C197 E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
0984 C199                       longa off
0985 C199                       longi off
0986 C199 A5 0C                 lda   device                   ; get device type
0987 C19B C9 03                 cmp   #3                       ; is it a legal device
0988 C19D 90 0A                 blt   DevOK                    ; yes
0989 C19F
0990 C19F C2 30                 rep   #$30                     ; added 3/21
0991 C1A1                       longa on                       ; added 3/21
0992 C1A1                       longi on                       ; added 3/21
0993 C1A1 A2 01 0C              ldx   #IllegalDeviceError      ; bad dev error
0994 C1A4 AB                    plb   
0995 C1A5 2B                    pld   
0996 C1A6              StatErr                                 ; 
0997 C1A6 4C 12 FC              jmp   oErrOut4
0998 C1A9
0999 C1A9
1000 C1A9                       longa off                      ; added 3/21
1001 C1A9                       longi off                      ; added 3/21
1002 C1A9              DevOK                                   ; 
1003 C1A9 A8                    tay                            ; index to get type
1004 C1AA A9 03                 lda   #3                       ; this is a status call
1005 C1AC 20 5D C5              jsr   MakeDDCB                 ; build the DDCB
1006 C1AF C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
1007 C1B1                       longa on
1008 C1B1                       longi on
1009 C1B1 A6 0A                 ldx   StatCode                 ; get the stat rqst code
1010 C1B3 DA                    phx   
1011 C1B4 20 89 C3              jsr   TTdsptch                 ; dispatch to device driver
1012 C1B7 FA                    plx                            ; get status
1013 C1B8 AB                    plb   
1014 C1B9 2B                    pld   
1015 C1BA B0 EA                 bcs   StatErr
1016 C1BC 4C 0D FC              jmp   oEndCall4
1017 C1BF
1018 C1BF                       ENDP 
1019 C1BF              ;          copy  text.tools/write.stuff
1020 C1BF                       EXPORT WrChar
1021 C1BF              WrChar   PROC 
1022 C1BF              ****************************************************************
1023 C1BF              *
1024 C1BF              * WRITE CHARACTER:
1025 C1BF              *
1026 C1BF              * Input     Byte	 Null
1027 C1BF              * Input     Byte	 Character
1028 C1BF              *
1029 C1BF              ****************************************************************
1030 C1BF                       longa on
1031 C1BF                       longi on
1032 C1BF
1033 C1BF              rtl1     equ   1
1034 C1BF              rtl2     equ   rtl1+3
1035 C1BF              TheChar  equ   rtl2+3
1036 C1BF
1037 C1BF B8                    clv                            ; set OUTPUT flag
1038 C1C0 50 02                 bvc   WChar
1039 C1C2                       EXPORT EWrChar
1040 C1C2              EWrChar                                 ; 
1041 C1C2 E2 40                 sep   #%01000000               ; set INPUT flag
1042 C1C4              WChar                                   ; 
1043 C1C4 A3 07                 lda   TheChar,s                ; get character
1044 C1C6 20 CD C1              jsr   SendOut                  ; and send to device
1045 C1C9
1046 C1C9 5C FC FB FE           jml   oErrOut2
1047 C1CD
1048 C1CD                       ENDP 
1049 C1CD
1050 C1CD              ****************************************************************
1051 C1CD              *
1052 C1CD              * SendItOut
1053 C1CD              *
1054 C1CD              * Sends the char in the A-reg out the device specified by the
1055 C1CD              * overflow flag after appropriate masking of the character.
1056 C1CD              *
1057 C1CD              * ENTRY:
1058 C1CD              *        V=0   Device is the output device
1059 C1CD              *        V=1   Device is the error output device
1060 C1CD              *        A-reg Character in low byte
1061 C1CD              *
1062 C1CD              * EXIT:
1063 C1CD              *        V=0   Device was the output device
1064 C1CD              *        V=1   Device was the error output device
1065 C1CD              *        C=0   No error resulted from dispatch
1066 C1CD              *        C=1   Error resulted from dispatch
1067 C1CD              *        X-reg Error code returned from device
1068 C1CD              *        A-reg trashed
1069 C1CD              *
1070 C1CD              *
1071 C1CD              * Change History
1072 C1CD              *
1073 C1CD              * 09 Aug 88	Steven Glass
1074 C1CD              *
1075 C1CD              * Comments above said error code came back in a-reg.  It
1076 C1CD              * comes back in x-reg.
1077 C1CD              *
1078 C1CD              ****************************************************************
1079 C1CD                       EXPORT SendOut
1080 C1CD              SendOut  PROC 
1081 C1CD                       longa on
1082 C1CD                       longi on
1083 C1CD
1084 C1CD 70 0D                 bvs   ESend                    ; if its an error output
1085 C1CF 2F AC 15 E1           and   >ANDout                  ; mask character with globals
1086 C1D3 0F AD 15 E1           ora   >ORout
1087 C1D7 A0 01 00              ldy   #1                       ; for output device Y=1
1088 C1DA 80 0B                 bra   SendChar
1089 C1DC                       EXPORT ESend
1090 C1DC              ESend                                   ; 
1091 C1DC 2F AE 15 E1           and   >ANDerr                  ; mask with globals
1092 C1E0 0F AF 15 E1           ora   >ORerr
1093 C1E4 A0 02 00              ldy   #2                       ; for error device Y=2
1094 C1E7                       EXPORT SendChar
1095 C1E7              SendChar                                ; 
1096 C1E7 48                    pha                            ; put the data word on the stack
1097 C1E8 5A                    phy                            ; save type
1098 C1E9 A9 02 00              lda   #2                       ; Write or Output call
1099 C1EC E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
1100 C1EE 20 5D C5              jsr   MakeDDCB                 ; build DDCB
1101 C1F1 C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
1102 C1F3 7A                    ply                            ; restore type
1103 C1F4 20 89 C3              jsr   TTdsptch                 ; call that thing
1104 C1F7 E2 20                 sep   #$20                     ; 8 bit 'm'
1105 C1F9                       longa off
1106 C1F9 98                    tya                            ; get back DDCB
1107 C1FA 4A                    lsr   a                        ; STD/ERR to bit 6
1108 C1FB 29 40                 and   #%01000000               ; only want device type
1109 C1FD B8                    clv   
1110 C1FE 08                    php   
1111 C1FF 03 01                 ora   1,s
1112 C201 83 01                 sta   1,s                      ; restore V=type
1113 C203 28                    plp   
1114 C204 C2 20                 rep   #$20                     ; 16 bit 'm'
1115 C206                       longa on
1116 C206 B0 05                 bcs   FixError
1117 C208 A2 00 00              ldx   #0
1118 C20B 80 05                 bra   CleanStack
1119 C20D 8A           FixError txa   
1120 C20E 09 00 0C              ora   #$0C00
1121 C211 AA                    tax   
1122 C212 68           CleanStack pla                          ; clean up our mess
1123 C213 60                    rts                            ; all done
1124 C214
1125 C214                       ENDP 
1126 C214
1127 C214
1128 C214                       EXPORT WrLine
1129 C214              WrLine   PROC 
1130 C214              ****************************************************************
1131 C214              *
1132 C214              * WRITE LINE
1133 C214              *
1134 C214              * Input     LongWord     Pointer
1135 C214              * This adds a CR/LF to the end of the string
1136 C214              *
1137 C214              ****************************************************************
1138 C214                       longa on
1139 C214                       longi on
1140 C214
1141 C214 B8                    clv                            ; set OUTPUT flag
1142 C215 50 02                 bvc   WLine
1143 C217                       EXPORT EWrLine
1144 C217              EWrLine                                 ; 
1145 C217 E2 40                 sep   #%01000000               ; set ERROR flag
1146 C219                       EXPORT WLine
1147 C219              WLine                                   ; 
1148 C219 20 41 C2              jsr   WrAStr                   ; send text string
1149 C21C B0 14                 bcs   WrLinErr                 ; if error occured
1150 C21E A9 0D 00              lda   #13                      ; now send a CR
1151 C221 20 CD C1              jsr   SendOut
1152 C224 B0 0C                 bcs   WrLinErr                 ; if error occured
1153 C226 98                    tya                            ; get DDCB
1154 C227 29 40 00              and   #%01000000               ; want driver type
1155 C22A F0 06                 beq   NoLF                     ; no LF if BASIC device
1156 C22C A9 0A 00              lda   #10                      ; no send a LF
1157 C22F 20 CD C1              jsr   SendOut
1158 C232
1159 C232                       EXPORT WrLinErr
1160 C232              WrLinErr                                ; 
1161 C232                       EXPORT NoLF
1162 C232              NoLF                                    ; 
1163 C232 5C 12 FC FE           jml   oErrOut4
1164 C236
1165 C236                       ENDP 
1166 C236
1167 C236
1168 C236
1169 C236
1170 C236                       EXPORT WrString
1171 C236              WrString PROC 
1172 C236              ****************************************************************
1173 C236              *
1174 C236              * WRITE STRING
1175 C236              *
1176 C236              * Input     LongWord     Pointer
1177 C236              *
1178 C236              ****************************************************************
1179 C236                       longa on
1180 C236                       longi on
1181 C236
1182 C236 B8                    clv                            ; set OUTPUT flag
1183 C237 50 02                 bvc   WStr
1184 C239                       EXPORT EWrStr
1185 C239              EWrStr                                  ; 
1186 C239 E2 40                 sep   #%01000000               ; set error flag
1187 C23B                       EXPORT WStr
1188 C23B              WStr                                    ; 
1189 C23B 20 41 C2              jsr   WrAStr                   ; send ASCII string
1190 C23E 4C 32 C2              jmp   WrLinErr                 ; if error occured
1191 C241
1192 C241
1193 C241                       ENDP 
1194 C241
1195 C241                       EXPORT WrAStr
1196 C241              WrAStr   PROC 
1197 C241              ****************************************************************
1198 C241              *
1199 C241              * WrAString
1200 C241              *
1201 C241              * Internal routine for use by WrLine and WrString.
1202 C241              *
1203 C241              ****************************************************************
1204 C241                       longa on
1205 C241                       longi on
1206 C241
1207 C241              OrigDir  equ   1
1208 C241              count    equ   OrigDir+2
1209 C241              RTSadr   equ   count+2
1210 C241              rtl1     equ   RTSadr+2
1211 C241              rtl2     equ   rtl1+3
1212 C241              TextPtr  equ   rtl2+3
1213 C241
1214 C241 48                    pha                            ; put extra word on stack for count
1215 C242 0B                    phd   
1216 C243 3B                    tsc   
1217 C244 5B                    tcd   
1218 C245 A7 0D                 lda   [TextPtr]                ; get count byte
1219 C247 29 FF 00              and   #$00FF                   ; limit to 256
1220 C24A 1A                    inc   a
1221 C24B 85 03                 sta   Count
1222 C24D A0 01 00              ldy   #1                       ; index past count byte
1223 C250                       EXPORT textloop
1224 C250              textloop                                ; 
1225 C250 C4 03                 cpy   Count                    ; done ?
1226 C252 F0 0C                 beq   AllDone                  ; yes
1227 C254 B7 0D                 lda   [TextPtr],y              ; get ascii data
1228 C256 5A                    phy                            ; save string index
1229 C257 20 CD C1              jsr   SendOut                  ; send character
1230 C25A 7A                    ply                            ; restore string index
1231 C25B C8                    iny                            ; and point at next character
1232 C25C B0 03                 bcs   AStrErr                  ; if error occured
1233 C25E 80 F0                 bra   TextLoop                 ; else go send next character
1234 C260
1235 C260                       EXPORT AllDone
1236 C260              AllDone                                 ; 
1237 C260 18                    clc                            ; clear error flag
1238 C261                       EXPORT AStrErr
1239 C261              AStrErr                                 ; 
1240 C261 2B                    pld                            ; restore direct
1241 C262 68                    pla                            ; clean off word
1242 C263 60                    rts   
1243 C264
1244 C264                       ENDP 
1245 C264
1246 C264
1247 C264
1248 C264                       EXPORT WrBlk
1249 C264              WrBlk    PROC 
1250 C264              ****************************************************************
1251 C264              *
1252 C264              * WRITE BLOCK:
1253 C264              *
1254 C264              * Input     LongWord     Pointer
1255 C264              * Input     Word	     Offset
1256 C264              * Input     Word	     Count
1257 C264              *
1258 C264              ****************************************************************
1259 C264                       longa on
1260 C264                       longi on
1261 C264
1262 C264              OrigDir  equ   1
1263 C264              RTL1     equ   OrigDir+2
1264 C264              RTL2     equ   RTL1+3
1265 C264              Count    equ   RTL2+3
1266 C264              Offset   equ   Count+2
1267 C264              TextPtr  equ   Offset+2
1268 C264
1269 C264              Counter  equ   Offset
1270 C264
1271 C264 B8                    clv                            ; set OUTPUT flag
1272 C265 50 02                 bvc   WBlk
1273 C267                       EXPORT EWrBlk
1274 C267              EWrBlk                                  ; 
1275 C267 E2 40                 sep   #%01000000               ; set ERROR flag
1276 C269                       EXPORT WBlk
1277 C269              WBlk                                    ; 
1278 C269 0B                    phd                            ; turn stack into zp
1279 C26A 3B                    tsc   
1280 C26B 5B                    tcd   
1281 C26C 08                    php                            ; save entry flag
1282 C26D 18                    clc                            ; ddr = addr + offset
1283 C26E A5 0D                 lda   TextPtr
1284 C270 65 0B                 adc   Offset
1285 C272 85 0D                 sta   TextPtr
1286 C274 A5 0F                 lda   TextPtr+2                ; Fixed 4 Sep 86 to work if crosses
1287 C276 69 00 00              adc   #0                       ; bank boundry. RBM
1288 C279 85 0F                 sta   TextPtr+2
1289 C27B 28                    plp                            ; restore entry flag
1290 C27C 64 0B                 stz   Counter                  ; init # chars sent
1291 C27E A4 0B        textloop ldy   Counter                  ; get # chars sent
1292 C280 C4 09                 cpy   Count                    ; done?
1293 C282 F0 0B                 beq   AllDone                  ; yes
1294 C284 B7 0D                 lda   [TextPtr],y              ; else get character
1295 C286 20 CD C1              jsr   SendOut                  ; and send to device
1296 C289 B0 04                 bcs   TextErr                  ; exit if device error
1297 C28B E6 0B                 inc   Counter                  ; point at next character
1298 C28D 80 EF                 bra   TextLoop
1299 C28F
1300 C28F              AllDone                                 ; 
1301 C28F              TextErr                                 ; 
1302 C28F 5C 3D FC FE           jml   ErrOut8
1303 C293
1304 C293                       ENDP 
1305 C293
1306 C293
1307 C293
1308 C293
1309 C293                       EXPORT WrCstr
1310 C293              WrCstr   PROC 
1311 C293              ****************************************************************
1312 C293              *
1313 C293              * WRITE C STRING
1314 C293              *
1315 C293              * Input     LongWord     Pointer
1316 C293              *
1317 C293              *
1318 C293              * Change History
1319 C293              *
1320 C293              * 09 Aug 88	Steven Glass
1321 C293              *
1322 C293              * When null string was passed, an error code equal to the
1323 C293              * call number was accidently returned.
1324 C293              *
1325 C293              *
1326 C293              ****************************************************************
1327 C293                       longa on
1328 C293                       longi on
1329 C293
1330 C293              OrigDir  equ   1
1331 C293              RTL1     equ   OrigDir+2
1332 C293              RTL2     equ   RTL1+3
1333 C293              TextPtr  equ   RTL2+3
1334 C293
1335 C293 B8                    clv                            ; set OUTPUT flag
1336 C294 50 02                 bvc   WCStr
1337 C296                       EXPORT EWrCStr
1338 C296              EWrCStr                                 ; 
1339 C296 E2 40                 sep   #%01000000               ; set ERROR flag
1340 C298                       EXPORT WCStr
1341 C298              WCStr                                   ; 
1342 C298 0B                    phd                            ; turn stack into zp
1343 C299 3B                    tsc   
1344 C29A 5B                    tcd   
1345 C29B
1346 C29B A2 00 00              ldx   #0                       ; init error code for null string case (SEG 09 Aug 88)
1347 C29E
1348 C29E A0 00 00              ldy   #0                       ; init string pointer
1349 C2A1              TextLoop                                ; 
1350 C2A1 B7 09                 lda   [TextPtr],y              ; get C-String ASCII
1351 C2A3 29 FF 00              and   #$00FF                   ; low byte only
1352 C2A6 F0 0A                 beq   AllDone                  ; $00 is string terminator
1353 C2A8 5A                    phy                            ; save string pointer
1354 C2A9 20 CD C1              jsr   SendOut                  ; send to Pascal device
1355 C2AC 7A                    ply                            ; restore string pointer
1356 C2AD C8                    iny                            ; and point at next char
1357 C2AE B0 02                 bcs   CStrErr                  ; if error occured, exit
1358 C2B0 80 EF                 bra   TextLoop                 ; else send next character
1359 C2B2
1360 C2B2              AllDone                                 ; 
1361 C2B2              CStrErr                                 ; 
1362 C2B2 5C 11 FC FE           jml   ErrOut4
1363 C2B6
1364 C2B6                       ENDP 
1365 C2B6              ;          copy  text.tools/read.stuff
1366 C2B6                       EXPORT RdChar
1367 C2B6              RdChar   PROC 
1368 C2B6              ****************************************************************
1369 C2B6              *
1370 C2B6              * READ CHARACTER:
1371 C2B6              *
1372 C2B6              * Input     Word     Space for result
1373 C2B6              * Input     Word     Echo flag (1=echo)
1374 C2B6              * Output    Word     Character
1375 C2B6              *
1376 C2B6              ****************************************************************
1377 C2B6                       longa on
1378 C2B6                       longi on
1379 C2B6
1380 C2B6              OrigDir  equ   1
1381 C2B6              rtl1     equ   OrigDir+2
1382 C2B6              rtl2     equ   rtl1+3
1383 C2B6              echo     equ   rtl2+3
1384 C2B6              TheChar  equ   Echo+2
1385 C2B6
1386 C2B6 0B                    phd                            ; turn stack into zp
1387 C2B7 3B                    tsc   
1388 C2B8 5B                    tcd   
1389 C2B9 20 DB C2              jsr   GetItIn                  ; Read character
1390 C2BC B0 1A                 bcs   RCharErr                 ; if error occured
1391 C2BE 2F AA 15 E1           and   >ANDin                   ; mask character with globals
1392 C2C2 0F AB 15 E1           ora   >ORin
1393 C2C6 85 0B                 sta   TheChar                  ; and store character to stack
1394 C2C8 A4 09                 ldy   echo                     ; is echo active ?
1395 C2CA F0 09                 beq   NoEcho
1396 C2CC B8                    clv                            ; to the output device
1397 C2CD 48                    pha                            ; character to stack
1398 C2CE A2 0C 18 22           _WriteChar                     ; and send it out
1399 C2D5              NoEcho                                  ; 
1400 C2D5 4C F8 FB              jmp   EndCall2
1401 C2D8
1402 C2D8                       EXPORT RCharErr
1403 C2D8              RCharErr                                ; 
1404 C2D8 4C FB FB              jmp   ErrOut2
1405 C2DB
1406 C2DB                       ENDP 
1407 C2DB
1408 C2DB
1409 C2DB
1410 C2DB
1411 C2DB                       EXPORT GetItIn
1412 C2DB              GetItIn  PROC 
1413 C2DB              ****************************************************************
1414 C2DB              *
1415 C2DB              * GetItIn
1416 C2DB              *
1417 C2DB              ****************************************************************
1418 C2DB                       longa on
1419 C2DB                       longi on
1420 C2DB
1421 C2DB A0 00 00              ldy   #0                       ; for input device Y=0
1422 C2DE F4 00 00              pea   $0000                    ; put room on the stack
1423 C2E1 E2 30                 sep   #$30                     ; 8 bit 'm'
1424 C2E3                       longa off
1425 C2E3 A9 01                 lda   #1                       ; this is a read call
1426 C2E5 20 5D C5              jsr   MakeDDCB                 ; build DDCB byte
1427 C2E8 C2 30                 rep   #$30                     ; 16 bit 'm'
1428 C2EA                       longa on
1429 C2EA 20 89 C3              jsr   TTdsptch                 ; call the driver
1430 C2ED E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
1431 C2EF                       longa off
1432 C2EF                       longi off
1433 C2EF 98                    tya                            ; get back DDCB
1434 C2F0 0A                    asl   a
1435 C2F1 29 40                 and   #%01000000               ; only want driver type
1436 C2F3 B8                    clv   
1437 C2F4 08                    php   
1438 C2F5 03 01                 ora   1,s
1439 C2F7 83 01                 sta   1,s
1440 C2F9 28                    plp   
1441 C2FA C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
1442 C2FC                       longa on
1443 C2FC                       longi on
1444 C2FC 68                    pla                            ; get result
1445 C2FD 60                    rts                            ; all done
1446 C2FE
1447 C2FE                       ENDP 
1448 C2FE
1449 C2FE
1450 C2FE                       EXPORT RdBlk
1451 C2FE              RdBlk    PROC 
1452 C2FE              ****************************************************************
1453 C2FE              *
1454 C2FE              * READ BLOCK:
1455 C2FE              *
1456 C2FE              * Input     LongWord Pointer
1457 C2FE              * Input     Word     Offset
1458 C2FE              * Input     Word     Count (Max.)
1459 C2FE              * Input     Word     Echo flag (1=echo)
1460 C2FE              *
1461 C2FE              ****************************************************************
1462 C2FE                       longa on
1463 C2FE                       longi on
1464 C2FE
1465 C2FE              OrigDir  equ   1
1466 C2FE              Rtl1     equ   OrigDir+2
1467 C2FE              Rtl2     equ   Rtl1+3
1468 C2FE              echo     equ   Rtl2+3
1469 C2FE              count    equ   echo+2
1470 C2FE              offset   equ   count+2
1471 C2FE              RXcount  equ   offset
1472 C2FE              pointer  equ   offset+2
1473 C2FE
1474 C2FE 0B                    phd                            ; save direct page
1475 C2FF 3B                    tsc                            ; and turn stack into zp
1476 C300 5B                    tcd   
1477 C301 08                    php                            ; save type
1478 C302 18                    clc                            ; add offset to pointer
1479 C303 A5 0D                 lda   offset
1480 C305 65 0F                 adc   pointer
1481 C307 85 0F                 sta   pointer
1482 C309 A9 00 00              lda   #0                       ; (32 bit add)
1483 C30C 65 11                 adc   pointer+2
1484 C30E 85 11                 sta   pointer+2
1485 C310 28                    plp                            ; restore type
1486 C311 64 0D                 stz   RXcount                  ; clear count received
1487 C313                       EXPORT RdBlk0
1488 C313              RdBlk0                                  ; 
1489 C313 48                    pha                            ; room for result
1490 C314 A5 09                 lda   echo                     ; pass echo flag to rdchar
1491 C316 48                    pha   
1492 C317 22 45 C3 FE           jsl   readit                   ; read character
1493 C31B B0 24                 bcs   RdBlkErr                 ; if error occured
1494 C31D 8B                    phb                            ; and data bank
1495 C31E 18                    clc   
1496 C31F E6 0D                 inc   RXcount                  ; incr received count
1497 C321 A6 0F                 ldx   pointer                  ; move pointer to X reg
1498 C323 E2 20                 sep   #$20                     ; 8 bit 'm'
1499 C325                       longa off
1500 C325 A5 11                 lda   pointer+2                ; get bank
1501 C327 48                    pha                            ; set pointer bank
1502 C328 AB                    plb   
1503 C329 A3 02                 lda   2,s                      ; get character
1504 C32B 9D 00 00              sta   |0,x                     ; write to buffer
1505 C32E C2 20                 rep   #$20                     ; 16 bit 'm'
1506 C330                       longa on
1507 C330 AB                    plb                            ; restore bank & direct page
1508 C331 68                    pla                            ; remove character
1509 C332 E6 0F                 inc   Pointer                  ; point at next buffer location
1510 C334 D0 02                 bne   NoPtrOv                  ; if no buffer overflow
1511 C336 E6 11                 inc   Pointer+2
1512 C338                       EXPORT NoPtrOv
1513 C338              NoPtrOv                                 ; 
1514 C338 A5 0D                 lda   RxCount                  ; rcvd count = maximum ?
1515 C33A C5 0B                 cmp   count                    ; count = maximum ?
1516 C33C D0 D5                 bne   RdBlk0                   ; no, get more
1517 C33E
1518 C33E                       EXPORT RdBlk2
1519 C33E              RdBlk2                                  ; 
1520 C33E 4C 50 FC              jmp   EndCall10                ; all done
1521 C341
1522 C341                       EXPORT RdBlkErr
1523 C341              RdBlkErr                                ; 
1524 C341 68                    pla                            ; clean up stack
1525 C342 4C 53 FC              jmp   ErrOut10                 ; oops!!!
1526 C345
1527 C345                       EXPORT ReadIt
1528 C345              ReadIt                                  ; 
1529 C345 22 B6 C2 FE           jsl   RdChar                   ; go read character
1530 C349 6B                    rtl   
1531 C34A
1532 C34A                       ENDP 
1533 C34A
1534 C34A
1535 C34A                       EXPORT RdLine
1536 C34A              RdLine   PROC 
1537 C34A              ****************************************************************
1538 C34A              *
1539 C34A              * READ LINE:
1540 C34A              *
1541 C34A              * Input     Word     Space for result
1542 C34A              * Input     LongWord Pointer
1543 C34A              * Input     Word     Count (max.)
1544 C34A              * Input     Word     EOL character
1545 C34A              * Input     Word     Echo flag (1=echo)
1546 C34A              * Output    Word     Count (rcvd)
1547 C34A              *
1548 C34A              ****************************************************************
1549 C34A
1550 C34A              OrigDir  equ   1
1551 C34A              rtl1     equ   OrigDir+2
1552 C34A              rtl2     equ   rtl1+3
1553 C34A              Echo     equ   rtl2+3
1554 C34A              EOLchar  equ   echo+2
1555 C34A              count    equ   EOLchar+2
1556 C34A              pointer  equ   count+2
1557 C34A              rxcount  equ   pointer+4
1558 C34A
1559 C34A 0B                    phd                            ; save direct page
1560 C34B 3B                    tsc                            ; and turn stack into zp
1561 C34C 5B                    tcd   
1562 C34D 64 13                 stz   RxCount                  ; initialize recv count
1563 C34F
1564 C34F                       EXPORT LinLoop
1565 C34F              LinLoop                                 ; 
1566 C34F 48                    pha                            ; room for character
1567 C350 A5 09                 lda   echo                     ; pass echo flag to rdchar
1568 C352 48                    pha   
1569 C353 22 45 C3 FE           jsl   ReadIt                   ; read character
1570 C357 68                    pla                            ; get character
1571 C358 B0 2C                 bcs   RlinErr                  ; if error occured
1572 C35A E2 20                 sep   #$20                     ; 8 bit 'm'
1573 C35C C5 0B                 cmp   EOLchar                  ; are we done yet?
1574 C35E C2 20                 rep   #$20                     ; 16 bit 'm'
1575 C360 F0 21                 beq   done                     ; yes
1576 C362 EB                    xba                            ; save character
1577 C363 A6 0F                 ldx   pointer                  ; X=addr
1578 C365 E2 20                 sep   #$20                     ; 8 bit m
1579 C367                       longa off
1580 C367 8B                    phb                            ; save data bank
1581 C368 A5 11                 lda   pointer+2                ; get pointer bank
1582 C36A 48                    pha   
1583 C36B AB                    plb   
1584 C36C EB                    xba                            ; get char
1585 C36D 9D 00 00              sta   |0,x                     ; send character to buffer
1586 C370 AB                    plb                            ; restore data bank
1587 C371 C2 20                 rep   #$20                     ; 16 bit m
1588 C373                       longa on
1589 C373 E6 0F                 inc   pointer                  ; point at next
1590 C375 D0 02                 bne   NoPtrOV                  ; if now overflow
1591 C377 E6 11                 inc   pointer+2
1592 C379              NoPtrOV                                 ; 
1593 C379 E6 13                 inc   RxCount                  ; increment bytes recvd
1594 C37B F0 09                 beq   RLinErr                  ; if overflow, then error
1595 C37D A5 13                 lda   rxcount
1596 C37F C5 0D                 cmp   count
1597 C381 D0 CC                 bne   LinLoop
1598 C383              Done                                    ; 
1599 C383 4C 50 FC              jmp   EndCall10                ; else all done
1600 C386
1601 C386                       EXPORT RLinErr
1602 C386              RLinErr                                 ; 
1603 C386 4C 53 FC              jmp   ErrOut10                 ; oops
1604 C389
1605 C389                       ENDP 
1606 C389
1607 C389
1608 C389
1609 C389
1610 C389              TTDsptch PROC 
1611 C389              ****************************************************************
1612 C389              *
1613 C389              * This routine is called to dispatch to both BASIC & PASCAL1.1
1614 C389              * device drivers.  Input to this routine is as follows.....
1615 C389              *
1616 C389              * ENTRY:
1617 C389              *        16 bit 'm' and 'x' native mode
1618 C389              *
1619 C389              *      Input   Word     Character (in low byte)
1620 C389              * sp->
1621 C389              *      A Register = DEVICE DISPATCHER CONTROL BYTE  
1622 C389              *      Y Register = Driver type   0 = Input device
1623 C389              *                                 1 = Output device
1624 C389              *                                 2 = Error device
1625 C389              *
1626 C389              * This routine returns with the CARRY bit set, and an error
1627 C389              * code on the stack if an error resulted from a dispatch to the
1628 C389              * BASIC, PASCAL1.1 or RAM BASED device driver.  If the call was
1629 C389              * to get input from the device, the data will be returned on the
1630 C389              * stack.  If the call was to send output to the device, the
1631 C389              * data returned on the stack is unspecified.
1632 C389              *
1633 C389              * EXIT:
1634 C389              *        16 bit 'm' and 'x' native mode
1635 C389              *
1636 C389              *      Output  Word     Returned data (in low byte)
1637 C389              * sp->
1638 C389              *      A Register = Error code
1639 C389              *      Carry = set for error, clear otherwise.  
1640 C389              *
1641 C389              * Low byte of Y register holds the DDCB from the dispatch
1642 C389              *
1643 C389              * The DEVICE DISPATCHER CONTROL BYTE is defined as follows:
1644 C389              *
1645 C389              *  ___ ___ ___ ___ ___ ___ ___ ___
1646 C389              * |   |   |   |   |   |   |   |   |
1647 C389              * | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
1648 C389              * |___|___|___|___|___|___|___|___|
1649 C389              *   |   |           |   |___|___|______ Call Type
1650 C389              *   |   |           | 0 = Initialization
1651 C389              *   |   |           | 1 = Read
1652 C389              *   |   |           | 2 = Write
1653 C389              *   |   |           | 3 = Status
1654 C389              *   |   |           | 4 = Control
1655 C389              *   |   |           |
1656 C389              *   |   |___________|__________________ Driver Type
1657 C389              *   |                 0 = BASIC
1658 C389              *   |                 1 = PASCAL
1659 C389              *   |
1660 C389              *   |__________________________________ Driver SubType
1661 C389              *                     0 = STANDARD
1662 C389              *                     1 = ERROR
1663 C389              *
1664 C389              *
1665 C389              * Change History
1666 C389              *
1667 C389              * 02 Aug 88	Steven Glass
1668 C389              *
1669 C389              * This routine trys to return an error in the a-reg, if the
1670 C389              * an initcall is being made to a device that is not there.
1671 C389              *
1672 C389              * On other calls the a-reg was not set and carry was undefined.
1673 C389              * Now, the a-reg will be zero if no error occurs and the 
1674 C389              * carry will be correct.
1675 C389              *
1676 C389              * 16 Nov 88	Konstantin Othmer
1677 C389              *
1678 C389              * Added support for slot arbiter by switching in proper slot.  I needed 
1679 C389              * a word to store the current slot configuration.  I get the space by
1680 C389              * moving the return address and TheChar down one word and then sticking
1681 C389              * the configuration where TheChar used to be.  The code at the very beginning
1682 C389              * and very end of the routine handle the stack manipulation.
1683 C389              *
1684 C389              ****************************************************************
1685 C389
1686 C389              BInit    equ   $C000                    ; BASIC init entry
1687 C389              BInput   equ   $FD0C                    ; BASIC input via rdkey entry
1688 C389              BOutput  equ   $FDED                    ; BASIC output via cout
1689 C389              PInit    equ   $C00D                    ; PASCAL init offset
1690 C389              PRead    equ   $C00E                    ; PASCAL read offset
1691 C389              PWrite   equ   $C00F                    ; PASCAL write offset
1692 C389              PStatus  equ   $C010                    ; PASCAL status offset
1693 C389              POption  equ   $C011                    ; PASCAL option flag
1694 C389              PControl equ   $C012                    ; PASCAL control offset
1695 C389
1696 C389              SaveHook equ   1
1697 C389              OrigStat equ   SaveHook+2
1698 C389              DDCB     equ   OrigStat+1
1699 C389              OrigDir  equ   DDCB+1
1700 C389              OrigDB   equ   OrigDir+2
1701 C389              RTSaddr  equ   OrigDB+1
1702 C389              TheChar  equ   RTSaddr+2
1703 C389
1704 C389 48                    pha                            ;make room for slot config on stack
1705 C38A AA                    tax                            ;save DDCB
1706 C38B A3 03                 lda   3,s                      ;return address
1707 C38D 83 01                 sta   1,s
1708 C38F A3 05                 lda   5,s                      ;TheChar
1709 C391 83 03                 sta   3,s
1710 C393              ;
1711 C393              ;now 5,s is empty and can be used to save slot configuration
1712 C393              ;
1713 C393 DA                    phx                            ;save DDCB (was in a)
1714 C394 5A                    phy                            ;save driver type
1715 C395
1716 C395              ;
1717 C395              ; Here we request the proper slot and save old configuration
1718 C395              ; on the stack (at 5,s).
1719 C395              ;
1720 C395
1721 C395 98                    tya                            ; point at device pointer
1722 C396 29 03 00              and   #$3
1723 C399
1724 C399              *** INPUT is messed up - requesting slot 3 for input?? ****
1725 C399
1726 C399 0A                    asl   a
1727 C39A 0A                    asl   a
1728 C39B AA                    tax   
1729 C39C BD B3 15              lda   |DevPtr,x                ;get slot arbiter slot number (1-15)
1730 C39F 29 0F 00              and   #$000f
1731 C3A2 22 08 02 E1           jsl   slot_arbiter             ;set our slot configuration
1732 C3A6 8A                    txa                            ;old slot configuration to a
1733 C3A7
1734 C3A7 7A                    ply   
1735 C3A8 FA                    plx                            ;get DDCB back 
1736 C3A9
1737 C3A9 83 05                 sta   5,s                      ;save old slot configuration under 
1738 C3AB                                                      ;return address and TheChar
1739 C3AB 8A                    txa                            ;put DDCB back in a
1740 C3AC              ;
1741 C3AC              ; End of slot_arbiter stuff
1742 C3AC              ;
1743 C3AC 8B                    phb                            ; save dbr and d-reg
1744 C3AD 0B                    phd   
1745 C3AE
1746 C3AE
1747 C3AE E2 20                 sep   #$20                     ; 8 bit 'm'
1748 C3B0                       longa off
1749 C3B0
1750 C3B0
1751 C3B0              ;-----------------------------------------------------------
1752 C3B0              ;
1753 C3B0              ; Set the data banke to bank E1 and see what kind of device
1754 C3B0              ; it is
1755 C3B0              ;
1756 C3B0
1757 C3B0 48                    pha                            ; save DDCB
1758 C3B1 F4 15 E1              pea   DevPtr/256               ; point at device type
1759 C3B4 AB                    plb   
1760 C3B5 AB                    plb   
1761 C3B6 B9 B0 15              lda   |DevType,y               ; get device type
1762 C3B9 C9 02                 cmp   #2                       ; is it a ram based driver ?
1763 C3BB D0 52                 bne   NotRB                    ; no
1764 C3BD
1765 C3BD              ;-----------------------------------------------------------
1766 C3BD              ;
1767 C3BD              ; Its a RAM driver.
1768 C3BD              ;
1769 C3BD
1770 C3BD E2 10                 sep   #$10                     ; 8 bit 'x'
1771 C3BF                       longi off
1772 C3BF 98                    tya                            ; point at device pointer
1773 C3C0 0A                    asl   a
1774 C3C1 0A                    asl   a
1775 C3C2 AA                    tax   
1776 C3C3 C2 10                 rep   #$10                     ; 16 bit 'x'
1777 C3C5                       longi on
1778 C3C5 A3 01                 lda   1,s                      ; get DDCB
1779 C3C7 48                    pha                            ; need its image
1780 C3C8 29 07                 and   #$07                     ; and make entry offset
1781 C3CA 83 01                 sta   1,s
1782 C3CC 0A                    asl   a
1783 C3CD 18                    clc   
1784 C3CE 63 01                 adc   1,s
1785 C3D0 83 01                 sta   1,s                      ; save entry offset
1786 C3D2 C2 20                 rep   #$20                     ; 16 bit 'm'
1787 C3D4                       longa on
1788 C3D4 29 FF 00              and   #$00FF                   ; offset is 16 bits wide now
1789 C3D7 18                    clc   
1790 C3D8 7D B3 15              adc   |DevPtr,x                ; calculate entry point
1791 C3DB A8                    tay   
1792 C3DC A9 00 00              lda   #0
1793 C3DF 7D B5 15              adc   |DevPtr+2,x
1794 C3E2 AA                    tax   
1795 C3E3 4B                    phk                            ; set dispatch return addr
1796 C3E4 F4 02 C4              pea   RBret-1
1797 C3E7 E2 20                 sep   #$20                     ; 8 bit 'm'
1798 C3E9 8A                    txa                            ; then set dispatch address
1799 C3EA 48                    pha   
1800 C3EB 5A                    phy   
1801 C3EC C2 20                 rep   #$20                     ; 16 bit 'm'
1802 C3EE 38                    sec   
1803 C3EF A3 01                 lda   1,s                      ; really need addr-1
1804 C3F1 E9 01 00              sbc   #1
1805 C3F4 83 01                 sta   1,s
1806 C3F6 E2 20                 sep   #$20                     ; 8 bit 'm'
1807 C3F8                       longa off
1808 C3F8 A3 03                 lda   3,s
1809 C3FA E9 00                 sbc   #0
1810 C3FC 83 03                 sta   3,s
1811 C3FE C2 20                 rep   #$20                     ; 16 bit 'm'
1812 C400                       longa on
1813 C400 A3 0E                 lda   14,s                     ; get character for driver
1814 C402
1815 C402 6B                    rtl                            ; dispatch to Ram driver
1816 C403
1817 C403              RBret                                   ; 
1818 C403 83 08                 sta   8,s                      ; save the returned character
1819 C405 E2 20                 sep   #$20                     ; 8 bit 'm'
1820 C407 68                    pla   
1821 C408 68                    pla                            ; clean off DDCB
1822 C409 A8                    tay                            ; DDCB must be in Y on return
1823 C40A C2 20                 rep   #$20                     ; 16 bit 'm'
1824 C40C
1825 C40C 82 06 01              brl   NoErrorExit
1826 C40F
1827 C40F
1828 C40F              ;-----------------------------------------------------------
1829 C40F              ;
1830 C40F              ; Its not a RAM driver, so its a BASIC or Pascal device
1831 C40F              ;
1832 C40F
1833 C40F
1834 C40F              NotRB                                   ; 
1835 C40F                       longa off                      ; were still in 8 bit 'm'
1836 C40F AF 68 C0 00           lda   >StateReg                ; save away state register
1837 C413 48                    pha   
1838 C414 A9 08                 lda   #%00001000               ; put in the ROM
1839 C416 8F 68 C0 00           sta   >StateReg
1840 C41A F4 00 00              pea   $0000                    ; space for hooks
1841 C41D 3B                    tsc                            ; turn stack into zp
1842 C41E 5B                    tcd   
1843 C41F A9 00                 lda   #0
1844 C421 EB                    xba                            ; need B=$00
1845 C422 98                    tya                            ; point at driver pointer
1846 C423 0A                    asl   a
1847 C424 0A                    asl   a
1848 C425 A8                    tay   
1849 C426 A5 04                 lda   DDCB                     ; get call type
1850 C428 29 0F                 and   #$0F
1851 C42A 0A                    asl   a
1852 C42B AA                    tax                            ; point into dispatch table
1853 C42C 24 04                 bit   DDCB                     ; V = Driver type
1854 C42E A5 04                 lda   DDCB                     ; Z=1 if BASIC input call
1855 C430 3A                    dec   a
1856 C431 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
1857 C433                       longa on
1858 C433                       longi on
1859 C433 D0 05                 bne   NotBIn                   ; if not basic input
1860 C435 A9 0C FD              lda   #BInput                  ; else set RDKEY
1861 C438 80 2C                 bra   NoOffset
1862 C43A
1863 C43A
1864 C43A              NotBIn                                  ; 
1865 C43A E2 20                 sep   #$20                     ; 8 bit 'm'
1866 C43C 3A                    dec   a
1867 C43D C2 20                 rep   #$20                     ; 16 bit 'm'
1868 C43F D0 05                 bne   NotBOut                  ; if not basic output
1869 C441
1870 C441              outputb                                 ; 
1871 C441 A9 ED FD              lda   #BOutput                 ; else set COUT
1872 C444 80 20                 bra   NoOffset
1873 C446
1874 C446              NotBOut                                 ; 
1875 C446 E2 20                 sep   #$20                     ; is it a basic error output?
1876 C448                       longa off
1877 C448 29 0F                 and   #$0F
1878 C44A C2 20                 rep   #$20
1879 C44C                       longa on
1880 C44C F0 F3                 beq   outputb                  ; yes
1881 C44E B9 B3 15              lda   |DevPtr,y                ; get driver pointer (slot)
1882 C451              ;
1883 C451              ; Convert to regular slot number (1-7).  Slot arbiter numbers go 1-15
1884 C451              ;
1885 C451 29 07 00              and   #$07
1886 C454 EB                    xba                            ; in high byte
1887 C455 09 00 C0              ora   #$C000                   ; make $Cn00
1888 C458 E2 20                 sep   #$20                     ; 8 bit 'm'
1889 C45A 4B                    phk   
1890 C45B AB                    plb   
1891 C45C 1D 3D C5              ora   |DTbl,x                  ; Addr = Root Addr + Slot
1892 C45F 50 05                 bvc   NoOffset                 ; no offset if BASIC device
1893 C461 AA                    tax                            ; else point at offset byte
1894 C462 BF 00 00 00           lda   >0,x                     ; and get offset
1895 C466
1896 C466              NoOffset                                ; 
1897 C466 C2 20                 rep   #$20                     ; 16 bit 'm'
1898 C468                       longa on
1899 C468 F4 E3 C4              pea   TTDret-1                 ; return address
1900 C46B 3A                    dec   a                        ; need dispatch address-1
1901 C46C 48                    pha   
1902 C46D 1A                    inc   a
1903 C46E EB                    xba                            ; need $Cn in X register
1904 C46F AA                    tax   
1905 C470 0A                    asl   a                        ; need $n0 in Y register
1906 C471 0A                    asl   a
1907 C472 0A                    asl   a
1908 C473 0A                    asl   a
1909 C474 A8                    tay   
1910 C475 A3 01                 lda   1,s                      ; get back dispatch address
1911 C477 1A                    inc   a
1912 C478 29 00 FF              and   #$FF00                   ; make it $Cn00
1913 C47B DA                    phx                            ; save dispatch X & Y
1914 C47C 5A                    phy   
1915 C47D AA                    tax   
1916 C47E 50 29                 bvc   ChkBasic                 ; don't check PASCAL ID if BASIC
1917 C480
1918 C480
1919 C480              CkPascal                                ; 
1920 C480 E2 20                 sep   #$20                     ; 8 bit 'm'
1921 C482 BF 05 00 00           lda   >5,x                     ; get PASCAL ID bytes
1922 C486 EB                    xba   
1923 C487 BF 07 00 00           lda   >7,x
1924 C48B C2 20                 rep   #$20                     ; 16 bit 'm'
1925 C48D                       longa on
1926 C48D C9 18 38              cmp   #$3818                   ; is signature OK?
1927 C490 F0 35                 beq   DevOK                    ; yes
1928 C492
1929 C492
1930 C492              BadDev                                  ; 
1931 C492 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
1932 C494                       longa on
1933 C494                       longi on
1934 C494
1935 C494 68                    pla                            ; clean off X
1936 C495 68                    pla                            ; clean off Y
1937 C496 68                    pla                            ; clean off dispatch addr
1938 C497 68                    pla                            ; clean off TTRET-1
1939 C498 68                    pla                            ; clean off HOOK space
1940 C499 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
1941 C49B                       longa off
1942 C49B                       longi off
1943 C49B 68                    pla                            ; restore state register
1944 C49C 8F 68 C0 00           sta   >StateReg
1945 C4A0 68                    pla                            ; clean off DDCB
1946 C4A1
1947 C4A1 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
1948 C4A3                       longa on
1949 C4A3                       longi on
1950 C4A3
1951 C4A3 A9 01 0C              lda   #IllegalDeviceError      ; illegal device error
1952 C4A6 82 6F 00              brl   ErrorExit
1953 C4A9
1954 C4A9
1955 C4A9
1956 C4A9              ChkBasic                                ; 
1957 C4A9 E2 20                 sep   #$20                     ; 8 bit 'm'
1958 C4AB                       longa off
1959 C4AB A5 04                 lda   DDCB                     ; is it a BASIC read call?
1960 C4AD 29 0F                 and   #$0F
1961 C4AF 3A                    dec   a
1962 C4B0 F0 15                 beq   DevOk                    ; yes
1963 C4B2 3A                    dec   a                        ; is it a BASIC write call?
1964 C4B3 F0 12                 beq   DevOk                    ; yes
1965 C4B5 A0 0A 00              ldy   #10
1966 C4B8 BF 00 00 00           lda   >0,x                     ; read it once
1967 C4BC F0 D4                 beq   BadDev                   ; cant be a BRK
1968 C4BE
1969 C4BE
1970 C4BE              CKBloop                                 ; 
1971 C4BE DF 00 00 00           cmp   >0,x                     ; read rom
1972 C4C2 D0 CE                 bne   BadDev                   ; if not same, then no device
1973 C4C4 88                    dey   
1974 C4C5 10 F7                 bpl   CKBloop                  ; check a bunch of times
1975 C4C7              DevOk                                   ; 
1976 C4C7 E2 20                 sep   #$20                     ; 8 bit 'm'
1977 C4C9                       longa off
1978 C4C9 7A                    ply                            ; restore dispatch X and Y
1979 C4CA FA                    plx   
1980 C4CB 24 04                 bit   DDCB                     ; get driver subtype
1981 C4CD C2 20                 rep   #$20                     ; 16 bit 'm'
1982 C4CF                       longa on
1983 C4CF 10 0E                 bpl   NotError                 ; if not an error driver
1984 C4D1 AF 36 00 00           lda   >CSW                     ; Save output hook
1985 C4D5 85 01                 sta   SaveHook
1986 C4D7 AF BF 15 E1           lda   >ErrHook                 ; and set the error hook
1987 C4DB 8F 36 00 00           sta   >CSW
1988 C4DF
1989 C4DF
1990 C4DF              NotError  
1991 C4DF                                                      ; 
1992 C4DF A5 0A                 lda   TheChar                  ; get character to send
1993 C4E1 82 3E F0              brl   FWentry                  ; its time to dispatch
1994 C4E4
1995 C4E4              TTDret     
1996 C4E4 85 0A                 sta   TheChar                  ; save return info
1997 C4E6 08                    php   
1998 C4E7 E2 20                 sep   #$20                     ; 8 bit 'm'
1999 C4E9                       longa off
2000 C4E9 A5 04                 lda   DDCB                     ; get dispatch type
2001 C4EB C9 4B                 cmp   #%01001011               ; was it a PASCAL status
2002 C4ED F0 03                 beq   NotBRet                  ; if PASCAL status save C
2003 C4EF 28                    plp                            ; else clear carry
2004 C4F0 18                    clc   
2005 C4F1 08                    php   
2006 C4F2
2007 C4F2              NotBRet                                 ; 
2008 C4F2 E2 20                 sep   #$20                     ; 8 bit 'm'
2009 C4F4 24 04                 bit   DDCB                     ; was it an error call?
2010 C4F6 C2 20                 rep   #$20                     ; 16 bit 'm'
2011 C4F8                       longa on
2012 C4F8 10 0E                 bpl   NotErr                   ; if not an error driver
2013 C4FA AF 36 00 00           lda   >CSW                     ; save error hook
2014 C4FE 8F BF 15 E1           sta   >ErrHook
2015 C502 A5 01                 lda   SaveHook                 ; restore output hook
2016 C504 8F 36 00 00           sta   >CSW
2017 C508
2018 C508              NotErr                                  ; 
2019 C508 28                    plp                            ; restore return info
2020 C509 68                    pla                            ; clean off hook space
2021 C50A E2 20                 sep   #$20                     ; 8 bit 'm'
2022 C50C                       longa off
2023 C50C 68                    pla                            ; restore state reg
2024 C50D 8F 68 C0 00           sta   >StateReg
2025 C511 68                    pla                            ; clean off DDCB
2026 C512 A8                    tay                            ; and save in low Y
2027 C513 C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
2028 C515                       longa on
2029 C515                       longi on
2030 C515
2031 C515 A9 00 00     NoErrorExit lda   #0
2032 C518              ErrorExit  
2033 C518 C9 01 00              cmp   #1
2034 C51B 2B                    pld   
2035 C51C AB                    plb   
2036 C51D              ;
2037 C51D              ; return slots to original configuration
2038 C51D              ;
2039 C51D AA                    tax                            ;save error code
2040 C51E A3 05                 lda   5,s                      ;get original slot configuration
2041 C520 DA                    phx                            ;error code to stack
2042 C521 08                    php   
2043 C522 AA                    tax   
2044 C523 5A                    phy   
2045 C524
2046 C524              ; 
2047 C524              ; Restore old slot configuration
2048 C524              ;
2049 C524 A9 00 03              lda   #$0300                   ;restore to configuration in x reg
2050 C527 22 08 02 E1           jsl   slot_arbiter
2051 C52B
2052 C52B 7A                    ply   
2053 C52C 28                    plp   
2054 C52D FA                    plx                            ;error code
2055 C52E              ; Need to fix stack
2056 C52E A3 03                 lda   3,s
2057 C530 83 05                 sta   5,s                      ;put TheChar back where it was
2058 C532 A3 01                 lda   1,s
2059 C534 83 03                 sta   3,s                      ;put return address back
2060 C536 68                    pla                            ;get empty space off
2061 C537 8A                    txa                            ;error code is returned in a reg.
2062 C538
2063 C538 8F 10 00 FF           sta   $FF0010
2064 C53C
2065 C53C 60                    rts   
2066 C53D
2067 C53D
2068 C53D              DTbl                                    ; 
2069 C53D 00 C0                 DC W:BInit                     ; BASIC init entry
2070 C53F 0C FD                 DC W:BInput                    ; BASIC input entry
2071 C541 ED FD                 DC W:BOutput                   ; BASIC output entry
2072 C543 00 00                 DC W:0
2073 C545 00 00                 DC W:0
2074 C547 00 00                 DC W:0
2075 C549 00 00                 DC W:0
2076 C54B 00 00                 DC W:0
2077 C54D 0D C0                 DC W:PInit                     ; PASCAL init offset
2078 C54F 0E C0                 DC W:PRead                     ; PASCAL read offset
2079 C551 0F C0                 DC W:PWrite                    ; PASCAL write offset
2080 C553 10 C0                 DC W:PStatus                   ; PASCAL status offset
2081 C555 12 C0                 DC W:PControl                  ; PASCAL control offset
2082 C557 00 00                 DC W:0
2083 C559 00 00                 DC W:0
2084 C55B 00 00                 DC W:0
2085 C55D
2086 C55D                       ENDP 
2087 C55D
2088 C55D
2089 C55D
2090 C55D                       EXPORT MakeDDCB
2091 C55D              MakeDDCB PROC 
2092 C55D              ****************************************************************
2093 C55D              *
2094 C55D              * This routine is to be called in native mode with 8 bit
2095 C55D              * 'm' and 'x'.  On entry, the accumulator should contain
2096 C55D              * the CALL TYPE, and the Y register should contain the
2097 C55D              * pointer to the DEVTYPE table entry for the device being
2098 C55D              * called.  The ouput contains the DDCB in the accumulator.
2099 C55D              *
2100 C55D              * Y=$0000...Device is the input device
2101 C55D              * Y=$0001...Device is the standard output device
2102 C55D              * Y=$0002...Device is the error output device
2103 C55D              *
2104 C55D              * Device types are as follows:
2105 C55D              *        $00 = BASIC
2106 C55D              *        $01 = PASCAL
2107 C55D              *        $02 = Ram based driver
2108 C55D              *
2109 C55D              ****************************************************************
2110 C55D                       longa off
2111 C55D                       longi off
2112 C55D 8B                    phb   
2113 C55E F4 15 E1              pea   DevType/256              ; point at devtype table
2114 C561 AB                    plb   
2115 C562 AB                    plb   
2116 C563 48                    pha                            ; save call type
2117 C564 B9 B0 15              lda   |DevType,y               ; get device type
2118 C567 F0 07                 beq   GotDDCB                  ; if its basic
2119 C569 3A                    dec   a
2120 C56A D0 04                 bne   GotDDCB                  ; if its RAM based
2121 C56C 68                    pla                            ; else set pascal bit
2122 C56D 09 48                 ora   #%01001000
2123 C56F 48                    pha   
2124 C570                       EXPORT GotDDCB
2125 C570              GotDDCB                                 ; 
2126 C570 C0 02                 cpy   #2                       ; is it an error device?
2127 C572 D0 04                 bne   NotErrD                  ; no
2128 C574 68                    pla                            ; else set error dev bit
2129 C575 09 80                 ora   #%10000000
2130 C577 48                    pha   
2131 C578                       EXPORT NotErrD
2132 C578              NotErrD                                 ; 
2133 C578 68                    pla                            ; get DDCB off stack
2134 C579 AB                    plb   
2135 C57A 60                    rts   
2136 C57B
2137 C57B
2138 C57B                       ENDP 
2139 C57B
2140 C57B
2141 C57B
2142 C57B                       END   
